<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    public function customer()
    {
        return $this->belongsTo('App\Models\Customer');
    }

    public function menuItems()
    {
        return $this->belongsToMany('App\Models\MenuItem', 'order_item');
    }

    public function invoice()
    {
        return $this->hasOne('App\Models\OrderInvoice');
    }

    public function paymentTransaction()
    {
        return $this->hasOne('App\Models\PaymentTransaction');
    }

    public function resturant()
    {
        return $this->belongsTo('App\Models\Resturant');
    }

    public function paymentWay()
    {
        return $this->belongsTo('App\Models\PaymentWay');
    }

    public function deliveryAddress()
    {
        return $this->hasOne('App\Models\DeliveryAddress');
    }

}